 /**
  * @file <loop-functions/example/ExampleAggregationLoopFunc.cpp>
  *
  * @author Antoine Ligot - <aligot@ulb.ac.be>
  *
  * @package ARGoS3-AutoMoDe
  *
  * @license MIT License
  */

#include "mission.h"

/****************************************/
/***************************************
TASK 3. AGGREGATION ON ONE STOP*/

ChocolateMission1LoopFunction::ChocolateMission1LoopFunction() {
  m_fRadius = 0.25;
  m_cCoordBlackSpot = CVector2(0.0,0.0);
  //m_cCoordWhiteSpot = CVector2(-0.8,-0.1);
  m_fObjectiveFunction = 0;
  m_unNumberEdges=6;
  sidesize=1;
  //bb=true;


  //m_robotmin=m_unNumberRobots;
 // m_decreaseRobots=0;
 // numRobots=m_robotmin;


  //m_CCoordRect1Pos = CVector2(0.8,1);
  //m_CCoordRect1 = CVector2(1.25,-0.6);

  //m_CCoordRect2Pos = CVector2(-0.8,-1);
  //m_CCoordRect2 = CVector2(-1.25,0.6);
}

/****************************************/
/****************************************/

ChocolateMission1LoopFunction::ChocolateMission1LoopFunction(const ChocolateMission1LoopFunction& orig) {}

/****************************************/
/****************************************/

ChocolateMission1LoopFunction::~ChocolateMission1LoopFunction() {}

/****************************************/
/****************************************/

void ChocolateMission1LoopFunction::Destroy() {}

/****************************************/
/****************************************/

Real ChocolateMission1LoopFunction::GetObjectiveFunction() {return m_fObjectiveFunction;}


//UInt32 ChocolateMission1LoopFunction::GetNumRobots(){
 // return numRobots;
//}

/****************************************/
/**

argos::CColor ChocolateMission1LoopFunction::GetFloorColor(const argos::CVector2& c_position_on_plane) {
  CVector2 vCurrentPoint(c_position_on_plane.GetX(), c_position_on_plane.GetY());
  Real d = (m_cCoordBlackSpot - vCurrentPoint).Length();
  if (d <= m_fRadius) {
    return CColor::BLACK;
  }

  return CColor::GRAY50;
}
**************************************/

argos::CColor ChocolateMission1LoopFunction::GetFloorColor(const argos::CVector2& c_position_on_plane){
  CVector2 vCurrentPoint(c_position_on_plane.GetX(), c_position_on_plane.GetY());
  Real d = (m_cCoordBlackSpot - vCurrentPoint).Length();
  if (d <= m_fRadius) {
    return CColor::BLACK;
  }
  return CColor::GRAY50;
}


void ChocolateMission1LoopFunction::PostStep() {

   CSpace::TMapPerType& tEpuckMap = GetSpace().GetEntitiesByType("epuck");
  CVector2 cEpuckPosition(0,0);
  for (CSpace::TMapPerType::iterator it = tEpuckMap.begin(); it != tEpuckMap.end(); ++it) {
  CEPuckEntity* pcEpuck = any_cast<CEPuckEntity*>(it->second);
  cEpuckPosition.Set(pcEpuck->GetEmbodiedEntity().GetOriginAnchor().Position.GetX(),
                       pcEpuck->GetEmbodiedEntity().GetOriginAnchor().Position.GetY());
    Real fDistanceSpot = (m_cCoordBlackSpot - cEpuckPosition).Length();
    if (fDistanceSpot <= m_fRadius) {
      m_fObjectiveFunction += 3;
    }
}

  
  
}


void ChocolateMission1LoopFunction::PostExperiment() {

 
  LOG << "Score_objective:" << m_fObjectiveFunction << std::endl;
}


Real ChocolateMission1LoopFunction::InnerRadious() {
       Real fInnerRadious = (sidesize) / (2 * Tan(CRadians::PI / m_unNumberEdges));
       return fInnerRadious;
}


void ChocolateMission1LoopFunction::Init(TConfigurationNode& t_tree) {
  CoreLoopFunctions::Init(t_tree);
  CRadians fAngle=(2*CRadians::PI)/m_unNumberEdges;
 // CQuaternion angleWall;
  fRadius=InnerRadious();
  // Center
 // angleWall.FromEulerAngles(CRadians::PI_OVER_TWO, CRadians::ZERO, CRadians::ZERO);
  //m_pcBoxCenter = new CBoxEntity("wall_center",
  //    CVector3(0, m_cPositionShelter.GetY() - (m_fHeightShelter/2)- (0.05/2), 0.0),
     // angleWall,
    //  false,
     // CVector3(0.05, m_fWidthShelter+0.05, 0.2));
  //AddEntity(*m_pcBoxCenter); 
  //std::to_string(i+55)


  for(UInt32 i = 0; i < m_unNumberEdges; ++i) {
      //std::ostringstream id;
     // id << this->GetId() << ".wall_" << i;
      std::ostringstream id;
      id  << ".wall_" << i;
      pcWall = new CBoxEntity(id.str().c_str(), CVector3((fRadius * Cos(fAngle * i)),
                                                                              (fRadius * Sin(fAngle * i)),
                                                                              0),
                               CQuaternion().FromEulerAngles(-CRadians::PI +(fAngle * i),CRadians::ZERO,CRadians::ZERO),
                               false,
                               CVector3(0.01,sidesize,0.08),
                               0.2);
      AddEntity(*pcWall);
    }
     CVector3 v3(0,0,0);
     
    cylinder=new CCylinderEntity("cyl12",v3, CQuaternion().FromEulerAngles(CRadians::ZERO,CRadians::ZERO,CRadians::ZERO), true, 0.34f, 0.2f, 0.2f);
    //CCylinderEntity* cl=&cylinder;
    AddEntity(*cylinder);

    MoveObstacles();

    RemoveEntity(*cylinder);


    // CSpace::TMapPerType& tEpuckMap = GetSpace().GetEntitiesByType("cylinder");
    // for (CSpace::TMapPerType::iterator it = tEpuckMap.begin(); it != tEpuckMap.end(); ++it){
        //    CCylinderEntity* pcylinder = any_cast<CCylinderEntity*>(it->second);
     //RemoveEntity(*pcylinder); 
  // }
   // GetSpace().Update();
  
}


void ChocolateMission1LoopFunction::Reset(){
  m_fObjectiveFunction = 0;
  CoreLoopFunctions::Reset();
}

void ChocolateMission1LoopFunction::MoveObstacles(){
 // CBoxEntity* pbox;
  bool bPlaced = false;
  UInt32 unTrials;
  CSpace::TMapPerType& tEpuckMap = GetSpace().GetEntitiesByType("box");
  UInt32 i =0;

  for (CSpace::TMapPerType::iterator it = tEpuckMap.begin(); it != tEpuckMap.end(); ++it) {
    CBoxEntity* pbox = any_cast<CBoxEntity*>(it->second);
   
    //const std::string ss="d";
    //const SBoundingBox* 
   // std::ostringstream id;
   // id  << ".cylinder_" << i;
    i++;
    //CCylinderEntity cylinder(std::to_string(i),v3, pbox->GetEmbodiedEntity().GetOriginAnchor().Orientation, true, 0.34f, 0.2f, 0.2f);
   // CCylinderEntity* cl=&cylinder;
   // cylinder.SetRadius(0.34f);
    //cylinder.
   // &ss,v3, pbox->GetEmbodiedEntity().GetOriginAnchor().Orientation, true, 0.34f, 0.2f, 0.2f);
   // CCylinderEntity cv("d",v3, pbox->GetEmbodiedEntity().GetOriginAnchor().Orientation, true, 0.34f, 0.2f, 0.2f);
   // cylinder=&cv;
    //CCylinderEntity* cc=&cylinder;
   // argos::CComposableEntity::AddComponent,
    //AddEntity(*cl);
    //cl->Init();
    //GetSpace().argos::CComposableEntity::AddComponent(cl);

    bool intersect=pbox->GetEmbodiedEntity().GetBoundingBox().Intersects(cylinder->GetEmbodiedEntity().GetBoundingBox());
    
    unTrials = 0;
    if (intersect){
      do{
         ++unTrials;
         CRadians angle=m_pcRng->Uniform(CRange<CRadians>(CRadians::ZERO, CRadians::PI_OVER_TWO)); 
         Real a = m_pcRng->Uniform(CRange<Real>(0.2f, 0.8f));
         CVector3 cBoxPosition3 = a*GetRandomPosition();
         bPlaced = MoveEntity(pbox->GetEmbodiedEntity(),
                            cBoxPosition3,
                           // pbox->GetEmbodiedEntity().GetOriginAnchor().Orientation,false);
                           CQuaternion().FromEulerAngles(angle,CRadians::ZERO,CRadians::ZERO), false);

       if (bPlaced) 
       {
         intersect=pbox->GetEmbodiedEntity().GetBoundingBox().Intersects(cylinder->GetEmbodiedEntity().GetBoundingBox());
       }
      }
      while(!bPlaced && intersect && unTrials < 10000);
      if(!bPlaced && intersect) {
       THROW_ARGOSEXCEPTION("Can't place obstacle");
     }
   }

   
  }
}

/*void ChocolateMission1LoopFunction::MoveObstacles(){
 // CBoxEntity* pbox;
  bool bPlaced = false;
  UInt32 unTrials;
  CSpace::TMapPerType& tEpuckMap = GetSpace().GetEntitiesByType("box");


  for (CSpace::TMapPerType::iterator it = tEpuckMap.begin(); it != tEpuckMap.end(); ++it) {
    CBoxEntity* pbox = any_cast<CBoxEntity*>(it->second);
    // Choose position at random
    CVector2 cBoxMinCorner(0,0);
    CVector2 cBoxMaxCorner(0,0);

    //CVector2 cBoxPosition(0,0);
   // cBoxPosition2.Set(pbox->GetEmbodiedEntity().GetOriginAnchor().Position.GetX(),
                     // pbox->GetEmbodiedEntity().GetOriginAnchor().Position.GetY());


     cBoxMinCorner.Set(pbox->GetEmbodiedEntity().GetBoundingBox().MinCorner.GetX(),
      pbox->GetEmbodiedEntity().GetBoundingBox().MinCorner.GetY());
     cBoxMaxCorner.Set(pbox->GetEmbodiedEntity().GetBoundingBox().MaxCorner.GetX(),
      pbox->GetEmbodiedEntity().GetBoundingBox().MaxCorner.GetY());
     //if (pbox->GetEmbodiedEntity().CalculateBoundingBox().WithinMinBoundIncludedMaxBoundIncluded(m_fRadius)){

      //GetBoundingBox  (   )
    bool bPlaced=false;
    bool check=false;
    int direction=1;
   if (IsWithinCircle(cBoxMinCorner, m_cCoordBlackSpot, m_fRadius) || IsWithinCircle(cBoxMaxCorner, m_cCoordBlackSpot, m_fRadius)){
    unTrials = 0;
    do {
       ++unTrials;
       check=true;
       Real a = m_pcRng->Uniform(CRange<Real>(0.2f, 0.8f));
       CVector3 cBoxPosition3 = a*GetRandomPosition();
       CVector2 newPosition(cBoxPosition3.GetX(),cBoxPosition3.GetY());

       CRadians angle; 
       //m_pcRng->Uniform(CRange<CRadians>(CRadians::ZERO, CRadians::TWO_PI))
       
       if (cBoxPosition3.GetX()<0 && cBoxPosition3.GetY()<0) angle=m_pcRng->Uniform(CRange<CRadians>(-CRadians::PI_OVER_TWO, CRadians::ZERO));
       else if(cBoxPosition3.GetX()<0 && cBoxPosition3.GetY()>0) angle=m_pcRng->Uniform(CRange<CRadians>(-CRadians::PI, -CRadians::PI_OVER_TWO));
       else if (cBoxPosition3.GetX()>0 && cBoxPosition3.GetY()>0) angle=m_pcRng->Uniform(CRange<CRadians>(CRadians::PI_OVER_TWO, CRadians::PI));
       else angle=m_pcRng->Uniform(CRange<CRadians>(CRadians::ZERO, CRadians::PI_OVER_TWO));
      angle=m_pcRng->Uniform(CRange<CRadians>(CRadians::ZERO, CRadians::PI_OVER_TWO));
      check=IsWithinCircle(newPosition, m_cCoordBlackSpot, m_fRadius);
      //angle= pbox->GetEmbodiedEntity().Orientation;
      if (!check){
       

       bPlaced = MoveEntity(pbox->GetEmbodiedEntity(),
                            cBoxPosition3,
                           // pbox->GetEmbodiedEntity().GetOriginAnchor().Orientation,false);
                           CQuaternion().FromEulerAngles(angle,CRadians::ZERO,CRadians::ZERO), false);
       if (bPlaced) 
       {
        cBoxMinCorner.Set(pbox->GetEmbodiedEntity().GetBoundingBox().MinCorner.GetX(),
        pbox->GetEmbodiedEntity().GetBoundingBox().MinCorner.GetY());
        cBoxMaxCorner.Set(pbox->GetEmbodiedEntity().GetBoundingBox().MaxCorner.GetX(),
        pbox->GetEmbodiedEntity().GetBoundingBox().MaxCorner.GetY());
        if (IsWithinCircle(cBoxMinCorner, m_cCoordBlackSpot, m_fRadius) || IsWithinCircle(cBoxMaxCorner, m_cCoordBlackSpot, m_fRadius)){
          check=true;
          bPlaced=false;
        }
        else {check=false;}
       }
     }
       //check=IsWithinCircle(newPosition, m_cCoordBlackSpot, m_fRadius);
                            //pbox->GetEmbodiedEntity().GetOriginAnchor().Orientation,false);
    } while(!bPlaced && check && unTrials < 100000);
   if(!bPlaced && !check) {
       THROW_ARGOSEXCEPTION("Can't place obstacle");
    }
    }
  }
}*/

bool ChocolateMission1LoopFunction::IsWithinCircle(CVector2 c_cEpuckPosition, CVector2& m_cCoordSpot, Real fRadius) {
  //CVector2 vCurrentPoint(c_position_on_plane.GetX(), c_position_on_plane.GetY());
  Real dis = (m_cCoordSpot - c_cEpuckPosition).Length();
  if (dis <= fRadius) {
    return true;
  }
  return false;
}

CVector3 ChocolateMission1LoopFunction::GetRandomPosition() {
  Real a;
  Real b;
  Real temp;
  bool bPlaced = false;
  UInt32 unTrials;
  Real fPosX;
  Real fPosY;
 // a = m_pcRng->Uniform(CRange<Real>(0.0f, 1.0f));
  //b = m_pcRng->Uniform(CRange<Real>(0.0f, 1.0f));
  // If b < a, swap them
 
  //Real fPosX = b * InnerRadious() * cos(2 * CRadians::PI.GetValue() * (a/b));
//  Real fPosY = b * InnerRadious() * sin(2 * CRadians::PI.GetValue() * (a/b));


    unTrials = 0;
    do {
       ++unTrials;
        a = m_pcRng->Uniform(CRange<Real>(0.0f, 1.0f));
        b = m_pcRng->Uniform(CRange<Real>(0.0f, 1.0f));
        if (b < a) {
            temp = a;
            a = b;
            b = temp;
        }
       fPosX = b * InnerRadious() * cos(2 * CRadians::PI.GetValue() * (a/b));
       fPosY = b * InnerRadious() * sin(2 * CRadians::PI.GetValue() * (a/b));
      // CVector3 cBoxPosition = GetRandomPosition();

       CVector2 ep = CVector2(fPosX,fPosY);
       bPlaced=IsWithinCircle(ep, m_cCoordBlackSpot, m_fRadius);
    } while(bPlaced && unTrials < 100);
    //if(bPlaced) {
     //  THROW_ARGOSEXCEPTION("Can't place obstacle");
   // }



  //CVector2 ep = CVector2(fPosX,fPosY);
 // if (IsWithinCircle(ep, m_cCoordBlackSpot, m_fRadius)){
 //  fPosX=fPosX+m_fRadius/2;
  // CVector2 dc=CVector2(fPosX, fPosY);
  // if(IsWithinCircle(dc, m_cCoordBlackSpot, m_fRadius)){
  // fPosY=fPosY+m_fRadius;
 // }
//}



 // Real fPosX = m_CCoordRect2Pos.GetX() + a*fabs(m_CCoordRect2Pos.GetX() - m_CCoordRect1Pos.GetX());
 // Real fPosY = m_CCoordRect2Pos.GetY() + b*fabs(m_CCoordRect2Pos.GetY() - m_CCoordRect1Pos.GetY());

 // Real fPosY = -1.0 + b * 0.8;
  //Real fPosX = -0.8 + b * 1.6;
 // Real fPosX = -1.0 + a * 0.6;


  return CVector3(fPosX, fPosY, 0);
}


REGISTER_LOOP_FUNCTIONS(ChocolateMission1LoopFunction, "chocolate_mission1_loop_functions");
